
<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between mb-3">
    <h4>Products</h4>
    <a href="/products/create" class="btn btn-primary">Add Product</a>
</div>
<table class="table table-bordered table-hover bg-white">
    <tr>
        <th>Image</th>
        <th>Name</th>
        <th>Price</th>
        <th>Qty</th>
        <th>Status</th>
        <th>Actions</th>
    </tr>
    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><img src="<?php echo e(asset('storage/'.$p->image)); ?>" width="60"></td>
        <td><?php echo e($p->name); ?></td>
        <td>$<?php echo e($p->price); ?></td>
        <td><?php echo e($p->quantity); ?></td>
        <td>
            <?php if($p->quantity == 0): ?>
            <span class="badge bg-danger">Out of Stock</span>
            <?php elseif($p->quantity < 5): ?>
                <span class="badge bg-warning">Low Stock</span>
                <?php else: ?>
                <span class="badge bg-success">In Stock</span>
                <?php endif; ?>
        </td>
        <td>
            <a href="/products/<?php echo e($p->id); ?>/edit" class="btn btn-sm btn
warning">Edit</a>
            <form method="POST" action="/products/<?php echo e($p->id); ?>" class="d-inline">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-sm btn-danger">Delete</button>
            </form>
        </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pureya-admin\resources\views/products/index.blade.php ENDPATH**/ ?>