@extends('layouts.app')
@section('content')
<div class="d-flex justify-content-between mb-3">
    <h4>Products</h4>
    <a href="/products/create" class="btn btn-primary">Add Product</a>
</div>
<table class="table table-bordered table-hover bg-white">
    <tr>
        <th>Image</th>
        <th>Name</th>
        <th>Price</th>
        <th>Qty</th>
        <th>Status</th>
        <th>Actions</th>
    </tr>
    @foreach($products as $p)
    <tr>
        <td><img src="{{ asset('storage/'.$p->image) }}" width="60"></td>
        <td>{{ $p->name }}</td>
        <td>${{ $p->price }}</td>
        <td>{{ $p->quantity }}</td>
        <td>
            @if($p->quantity == 0)
            <span class="badge bg-danger">Out of Stock</span>
            @elseif($p->quantity < 5)
                <span class="badge bg-warning">Low Stock</span>
                @else
                <span class="badge bg-success">In Stock</span>
                @endif
        </td>
        <td>
            <a href="/products/{{ $p->id }}/edit" class="btn btn-sm btn
warning">Edit</a>
            <form method="POST" action="/products/{{ $p->id }}" class="d-inline">
                @csrf @method('DELETE')
                <button class="btn btn-sm btn-danger">Delete</button>
            </form>
        </td>
    </tr>
    @endforeach
</table>
@endsection