@extends('layouts.app')
@section('content')
<h4>Order #{{ $order->id }}</h4>
<div class="card mb-3">
    <div class="card-body">
        <strong>Customer:</strong> {{ $order->customer_name }}<br>
        <strong>Email:</strong> {{ $order->customer_email }}<br>
        <strong>Address:</strong> {{ $order->customer_address }}<br>
        <strong>Status:</strong>
        <span id="order-status" class="badge {{ $order->status == 'pending' ? 
'bg-warning' : 'bg-success' }}">
            {{ ucfirst($order->status) }}
        </span>
    </div>
</div>
<table class="table table-bordered bg-white">
    <tr>
        <th>Product</th>
        <th>Price</th>

        <th>Qty</th>
        <th>Subtotal</th>
    </tr>
    @foreach(json_decode($order->items, true) as $item)
    <tr>
        <td>{{ $item['name'] }}</td>
        <td>${{ $item['price'] }}</td>
        <td>{{ $item['qty'] }}</td>
        <td>${{ $item['price'] * $item['qty'] }}</td>
    </tr>
    @endforeach
    <tr>
        <th colspan="3" class="text-end">Total</th>
        <th>${{ $order->total }}</th>
    </tr>
</table>
<button id="completeOrder" class="btn btn-success">Mark Completed</button>
<a href="/orders/{{ $order->id }}/invoice" target="_blank" class="btn btn
outline-secondary">Print Invoice</a>
@endsection