<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;

class OrderController extends Controller
{
    public function index()
    {
        return view('orders.index', [
            'orders' => Order::latest()->get()

        ]);
    }
    public function show(Order $order)
    {
        return view('orders.show', compact('order'));
    }
    public function updateStatus(Order $order)
    {
        $order->update([
            'status' => 'completed'
        ]);
        return back();
    }
}
