<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Product;

class DashboardController extends Controller
{
    public function index()
    {
        return view('dashboard', [
            'totalRevenue' => Order::where('status', 'completed')->sum('total'),
            'totalOrders'  => Order::count(),
            'totalProducts'=> Product::count(),
            'lowStock'     => Product::where('quantity', '<', 5)->count(),
        ]);
    }
}
